/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.action;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.comp.LogoJMenu;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import javax.help.CSH;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class LogoJMenuBar
extends JMenuBar {
    protected WeakReference fActionGroupReference;

    public LogoJMenuBar() {
    }

    public LogoJMenuBar(ActionGroup actionGroup) {
        this.fActionGroupReference = new WeakReference<ActionGroup>(actionGroup);
        this.createMenuBar(actionGroup);
    }

    public JMenu add(ActionGroup actionGroup) {
        LogoJMenu logoMenu = new LogoJMenu(actionGroup);
        super.add(logoMenu);
        String textKey = (String)actionGroup.getValue("textKey");
        String defaultText = (String)actionGroup.getValue("defaultText");
        if (textKey != null) {
            this.setStringAndAccelerator(logoMenu, textKey, defaultText);
            CSH.setHelpIDString((Component)logoMenu, (String)textKey);
        }
        return logoMenu;
    }

    public void closeAllMenus() {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            this.closeMenuRecursive(this.getMenu(i));
        }
    }

    protected void closeMenuRecursive(JMenu menu) {
        Component c = null;
        if (menu.getPopupMenu().isVisible()) {
            menu.getPopupMenu().setVisible(false);
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                c = menu.getMenuComponent(i);
                if (!(c instanceof JMenu)) continue;
                this.closeMenuRecursive((JMenu)c);
            }
        }
    }

    protected void createMenuBar(ActionGroup actionGroup) {
        this.removeAll();
        if (actionGroup == null) {
            return;
        }
        Iterator i = actionGroup.getActions().iterator();
        while (i.hasNext()) {
            this.add((ActionGroup)i.next());
        }
    }

    protected void setStringAndAccelerator(JMenuItem item, String resourceKey, String defaultString) {
        KeyStroke keyStroke;
        Object ks = null;
        Hashtable ht = new Hashtable();
        if (defaultString == null) {
            defaultString = resourceKey;
        }
        String str = Language.getStringAndAccelerator(resourceKey, defaultString, ht);
        item.setText(str);
        Integer keyEvent = (Integer)ht.get("KeyEvent");
        if (keyEvent != null) {
            item.setMnemonic(keyEvent);
        }
        if ((keyStroke = (KeyStroke)ht.get("KeyStroke")) != null) {
            item.setAccelerator(keyStroke);
        }
    }

    public void unregisterMenuItemsForActions() {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            ((LogoJMenu)c[i]).unregisterMenuItemsForActions();
        }
    }
}

